# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# Restricted Materials of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

######################################################################
##                                                                   #
## Routine: i_stub_msg                                               #
##                                                                   #
##                                                                   #
##-------------------------------------------------------------------#
##                                                                   #
## Description: Determines what message should be printed            #
##              based on an i_stub_FS return code                    #
##                                                                   #
## Inputs : i_stub_FS return code set in $i_stub_return              #
##                                                                   #
## Outputs: $RC_MSG = message to be displayed                        #
##                                                                   #
## Syntax (example):                                                 #
##       i_stub_msg                                                  #
##                                                                   #
## External Ref: None                                                #
##                                                                   #
## Internal Ref: None                                                #
##                                                                   #
######################################################################

sub i_stub_msg {
	SWITCH:  {

		if ($i_stub_return == 19) {
			$RC_MSG = "Diagnostic state is not set on the requested switch chip.\n";
			last SWITCH;
		}

		if ($i_stub_return == 20) {
			$RC_MSG = "Could not update device database\n";
			last SWITCH;
		}

		if ($i_stub_return == 21) {
			$RC_MSG = "Riser card is not seating properly.\n";
			last SWITCH;
		}

		if ($i_stub_return == 22) {
			$RC_MSG = "Self-test on requested switch chip failed.\n";
			last SWITCH;
		}

		if ($i_stub_return == 23) {
			$RC_MSG = "Line Continuity test failed.\n";
			last SWITCH;
		}

		if ($i_stub_return == 24) {
			$RC_MSG = "Link-synchronization error is present on requested link.\n";
			last SWITCH;
		}

		if ($i_stub_return == 27) {
			$RC_MSG = "Link is not operational.\n";
			last SWITCH;
		}

		if ($i_stub_return == 50) {
			$RC_MSG = "Error communicating with SNM daemon\n";
			last SWITCH;
		}

		if ($i_stub_return == 51) {
			$RC_MSG = "Requested location (frame, cage, or link) is invalid\n";
			last SWITCH;
		}

		if ($i_stub_return == 52) {
			$RC_MSG = "Device database is not ready\n";
			last SWITCH;
		}

		if ($i_stub_return == 53) {
			$RC_MSG = "Requested frame is powered down\n";
			last SWITCH;
		}

		if ($i_stub_return == 54) {
			$RC_MSG = "Error communicating with Hardware Server daemon\n";
			last SWITCH;
		}

		DEFAULT:   $RC_MSG = "Unrecognized error - i_stub_FS return code was $i_stub_return \n";
	}
}

######################################################################
## Following line is to ensure that "require" statement succeeds.    #
######################################################################
1;
